/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl.templates;

import java.util.Map;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;
import org.drools.ide.common.client.modeldriven.brl.templates.InterpolationVariable;

public class RuleModelVisitor {
    private IFactPattern factPattern;
    private RuleModel model = new RuleModel();
    private Map<InterpolationVariable, Integer> vars;

    public RuleModelVisitor(Map<InterpolationVariable, Integer> vars) {
        this.vars = vars;
    }

    public RuleModelVisitor(IPattern pattern, Map<InterpolationVariable, Integer> vars) {
        this.vars = vars;
        this.model.addLhsItem(pattern);
    }

    public RuleModelVisitor(IAction action, Map<InterpolationVariable, Integer> vars) {
        this.vars = vars;
        this.model.addRhsItem(action);
    }

    private void parseStringPattern(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        int pos = 0;
        while ((pos = text.indexOf("@{", pos)) != -1) {
            int end = text.indexOf(125, pos + 2);
            if (end == -1) continue;
            String varName = text.substring(pos + 2, end);
            pos = end + 1;
            InterpolationVariable var = new InterpolationVariable(varName, "Object");
            if (this.vars.containsKey(var)) continue;
            this.vars.put(var, this.vars.size());
        }
    }

    public void visit(Object o) {
        if (o == null) {
            return;
        }
        if (o instanceof RuleModel) {
            this.visitRuleModel((RuleModel)o);
        } else if (o instanceof FactPattern) {
            this.visitFactPattern((FactPattern)o);
        } else if (o instanceof CompositeFieldConstraint) {
            this.visitCompositeFieldConstraint((CompositeFieldConstraint)o);
        } else if (o instanceof SingleFieldConstraintEBLeftSide) {
            this.visitSingleFieldConstraint((SingleFieldConstraintEBLeftSide)o);
        } else if (o instanceof SingleFieldConstraint) {
            this.visitSingleFieldConstraint((SingleFieldConstraint)o);
        } else if (o instanceof CompositeFactPattern) {
            this.visitCompositeFactPattern((CompositeFactPattern)o);
        } else if (o instanceof FreeFormLine) {
            this.visitFreeFormLine((FreeFormLine)o);
        } else if (o instanceof FromAccumulateCompositeFactPattern) {
            this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)o);
        } else if (o instanceof FromCollectCompositeFactPattern) {
            this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)o);
        } else if (o instanceof FromCompositeFactPattern) {
            this.visitFromCompositeFactPattern((FromCompositeFactPattern)o);
        } else if (o instanceof DSLSentence) {
            this.visitDSLSentence((DSLSentence)o);
        } else if (o instanceof ActionInsertFact) {
            this.visitActionFieldList((ActionInsertFact)o);
        } else if (o instanceof ActionUpdateField) {
            this.visitActionFieldList((ActionUpdateField)o);
        } else if (o instanceof ActionSetField) {
            this.visitActionFieldList((ActionSetField)o);
        }
    }

    private void visitActionFieldList(ActionInsertFact afl) {
        String factType = afl.factType;
        for (ActionFieldValue afv : afl.fieldValues) {
            InterpolationVariable var = new InterpolationVariable(afv.getValue(), afv.getType(), factType, afv.getField());
            if (afv.nature != 7L || this.vars.containsKey(var)) continue;
            this.vars.put(var, this.vars.size());
        }
    }

    private void visitActionFieldList(ActionSetField afl) {
        String factType = this.model.getLHSBindingType(afl.variable);
        for (ActionFieldValue afv : afl.fieldValues) {
            InterpolationVariable var = new InterpolationVariable(afv.getValue(), afv.getType(), factType, afv.getField());
            if (afv.nature != 7L || this.vars.containsKey(var)) continue;
            this.vars.put(var, this.vars.size());
        }
    }

    private void visitActionFieldList(ActionUpdateField afl) {
        String factType = this.model.getLHSBindingType(afl.variable);
        for (ActionFieldValue afv : afl.fieldValues) {
            InterpolationVariable var = new InterpolationVariable(afv.getValue(), afv.getType(), factType, afv.getField());
            if (afv.nature != 7L || this.vars.containsKey(var)) continue;
            this.vars.put(var, this.vars.size());
        }
    }

    private void visitCompositeFactPattern(CompositeFactPattern pattern) {
        if (pattern.getPatterns() != null) {
            for (IFactPattern fp : pattern.getPatterns()) {
                this.visit(fp);
            }
        }
    }

    private void visitCompositeFieldConstraint(CompositeFieldConstraint cfc) {
        if (cfc.constraints != null) {
            for (FieldConstraint fc : cfc.constraints) {
                this.visit(fc);
            }
        }
    }

    private void visitDSLSentence(DSLSentence sentence) {
        String text = sentence.getDefinition();
        this.parseStringPattern(text);
    }

    private void visitFactPattern(FactPattern pattern) {
        this.factPattern = pattern;
        for (FieldConstraint fc : pattern.getFieldConstraints()) {
            this.visit(fc);
        }
    }

    private void visitFreeFormLine(FreeFormLine ffl) {
        this.parseStringPattern(ffl.text);
    }

    private void visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern) {
        this.visit(pattern.getFactPattern());
        this.visit(pattern.getSourcePattern());
        this.parseStringPattern(pattern.getActionCode());
        this.parseStringPattern(pattern.getInitCode());
        this.parseStringPattern(pattern.getReverseCode());
    }

    private void visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern) {
        this.visit(pattern.getFactPattern());
        this.visit(pattern.getRightPattern());
    }

    private void visitFromCompositeFactPattern(FromCompositeFactPattern pattern) {
        this.visit(pattern.getFactPattern());
        this.parseStringPattern(pattern.getExpression().getText());
    }

    private void visitRuleModel(RuleModel model) {
        this.model = model;
        if (model.lhs != null) {
            for (PortableObject portableObject : model.lhs) {
                this.visit(portableObject);
            }
        }
        if (model.rhs != null) {
            for (PortableObject portableObject : model.rhs) {
                this.visit(portableObject);
            }
        }
    }

    private void visitSingleFieldConstraint(SingleFieldConstraint sfc) {
        InterpolationVariable var = new InterpolationVariable(sfc.getValue(), sfc.getFieldType(), this.factPattern.getFactType(), sfc.getFieldName());
        if (7 == sfc.getConstraintValueType() && !this.vars.containsKey(var)) {
            this.vars.put(var, this.vars.size());
        }
        if (sfc.connectives != null) {
            for (int i = 0; i < sfc.connectives.length; ++i) {
                ConnectiveConstraint cc = sfc.connectives[i];
                InterpolationVariable ccVar = new InterpolationVariable(cc.getValue(), cc.getFieldType(), this.factPattern.getFactType(), cc.getFieldName());
                if (7 != cc.getConstraintValueType() || this.vars.containsKey(ccVar)) continue;
                this.vars.put(ccVar, this.vars.size());
            }
        }
    }

    private void visitSingleFieldConstraint(SingleFieldConstraintEBLeftSide sfexp) {
        String genericType = sfexp.getExpressionLeftSide().getGenericType();
        String factType = sfexp.getExpressionLeftSide().getPreviousClassType();
        if (factType == null) {
            factType = sfexp.getExpressionLeftSide().getClassType();
        }
        InterpolationVariable var = new InterpolationVariable(sfexp.getValue(), genericType, factType, sfexp.getFieldName());
        if (7 == sfexp.getConstraintValueType() && !this.vars.containsKey(var)) {
            this.vars.put(var, this.vars.size());
        }
        if (sfexp.connectives != null) {
            for (int i = 0; i < sfexp.connectives.length; ++i) {
                ConnectiveConstraint cc = sfexp.connectives[i];
                InterpolationVariable ccVar = new InterpolationVariable(cc.getValue(), genericType, factType, cc.getFieldName());
                if (7 != cc.getConstraintValueType() || this.vars.containsKey(ccVar)) continue;
                this.vars.put(ccVar, this.vars.size());
            }
        }
    }
}

